/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.Stylesheet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Declaration {
    final String property;
    final ParsedValue parsedValue;
    final boolean important;
    Rule rule;

    public Declaration(String string, ParsedValue parsedValue, boolean bl) {
        this.property = string;
        this.parsedValue = parsedValue;
        this.important = bl;
    }

    public ParsedValue getParsedValue() {
        return this.parsedValue;
    }

    public String getProperty() {
        return this.property;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean isImportant() {
        return this.important;
    }

    private Stylesheet.Origin getOrigin() {
        Rule rule = this.getRule();
        if (rule != null) {
            return rule.getOrigin();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Declaration declaration = (Declaration)object;
        if (this.important != declaration.important) {
            return false;
        }
        if (this.getOrigin() != declaration.getOrigin()) {
            return false;
        }
        if (this.property == null ? declaration.property != null : !this.property.equals(declaration.property)) {
            return false;
        }
        return this.parsedValue == declaration.parsedValue || this.parsedValue != null && this.parsedValue.equals(declaration.parsedValue);
    }

    public int hashCode() {
        int n = 5;
        n = 89 * n + (this.property != null ? this.property.hashCode() : 0);
        n = 89 * n + (this.parsedValue != null ? this.parsedValue.hashCode() : 0);
        n = 89 * n + (this.important ? 1 : 0);
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.property);
        stringBuilder.append(": ");
        stringBuilder.append(this.parsedValue);
        if (this.important) {
            stringBuilder.append(" !important");
        }
        return stringBuilder.toString();
    }

    void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        dataOutputStream.writeShort(stringStore.addString(this.property));
        this.parsedValue.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeBoolean(this.important);
    }

    static Declaration readBinary(int n, DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        ParsedValue parsedValue = ParsedValue.readBinary(n, dataInputStream, stringArray);
        boolean bl = dataInputStream.readBoolean();
        return new Declaration(string, parsedValue, bl);
    }
}

