/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPart;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundFaultImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPartImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class WSDLBoundOperationImpl
extends AbstractExtensibleImpl
implements WSDLBoundOperation {
    private final QName name;
    private final Map<String, ParameterBinding> inputParts;
    private final Map<String, ParameterBinding> outputParts;
    private final Map<String, ParameterBinding> faultParts;
    private final Map<String, String> inputMimeTypes;
    private final Map<String, String> outputMimeTypes;
    private final Map<String, String> faultMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private boolean explicitFaultSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Boolean emptyFaultBody;
    private final Map<String, WSDLPartImpl> inParts;
    private final Map<String, WSDLPartImpl> outParts;
    private final Map<String, WSDLPartImpl> fltParts;
    private final List<WSDLBoundFaultImpl> wsdlBoundFaults;
    private WSDLOperationImpl operation;
    private String soapAction;
    private WSDLBoundOperation.ANONYMOUS anonymous;
    private final WSDLBoundPortTypeImpl owner;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private String reqNamespace;
    private String respNamespace;
    private QName requestPayloadName;
    private QName responsePayloadName;
    private boolean emptyRequestPayload;
    private boolean emptyResponsePayload;
    private Map<QName, WSDLMessageImpl> messages;

    public WSDLBoundOperationImpl(XMLStreamReader xMLStreamReader, WSDLBoundPortTypeImpl wSDLBoundPortTypeImpl, QName qName) {
        super(xMLStreamReader);
        this.name = qName;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.faultParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.faultMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, WSDLPartImpl>();
        this.outParts = new HashMap<String, WSDLPartImpl>();
        this.fltParts = new HashMap<String, WSDLPartImpl>();
        this.wsdlBoundFaults = new ArrayList<WSDLBoundFaultImpl>();
        this.owner = wSDLBoundPortTypeImpl;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getSOAPAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string != null ? string : "";
    }

    @Override
    public WSDLPartImpl getPart(String string, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            return this.inParts.get(string);
        }
        if (mode == WebParam.Mode.OUT) {
            return this.outParts.get(string);
        }
        return null;
    }

    public void addPart(WSDLPartImpl wSDLPartImpl, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            this.inParts.put(wSDLPartImpl.getName(), wSDLPartImpl);
        } else if (mode == WebParam.Mode.OUT) {
            this.outParts.put(wSDLPartImpl.getName(), wSDLPartImpl);
        }
    }

    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    public Map<String, ParameterBinding> getFaultParts() {
        return this.faultParts;
    }

    @Override
    public Map<String, WSDLPart> getInParts() {
        return Collections.unmodifiableMap(this.inParts);
    }

    @Override
    public Map<String, WSDLPart> getOutParts() {
        return Collections.unmodifiableMap(this.outParts);
    }

    @NotNull
    public List<WSDLBoundFaultImpl> getFaults() {
        return this.wsdlBoundFaults;
    }

    public void addFault(@NotNull WSDLBoundFaultImpl wSDLBoundFaultImpl) {
        this.wsdlBoundFaults.add(wSDLBoundFaultImpl);
    }

    public Map<String, String> getInputMimeTypes() {
        return this.inputMimeTypes;
    }

    public Map<String, String> getOutputMimeTypes() {
        return this.outputMimeTypes;
    }

    public Map<String, String> getFaultMimeTypes() {
        return this.faultMimeTypes;
    }

    public ParameterBinding getInputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.inputParts.get(string)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    public ParameterBinding getOutputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.outputParts.get(string)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    public ParameterBinding getFaultBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyFaultBody == null) {
            this.emptyFaultBody = this.faultParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.faultParts.get(string)) == null) {
            if (this.explicitFaultSOAPBodyParts || this.emptyFaultBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    public String getMimeTypeForInputPart(String string) {
        return this.inputMimeTypes.get(string);
    }

    public String getMimeTypeForOutputPart(String string) {
        return this.outputMimeTypes.get(string);
    }

    public String getMimeTypeForFaultPart(String string) {
        return this.faultMimeTypes.get(string);
    }

    @Override
    public WSDLOperationImpl getOperation() {
        return this.operation;
    }

    @Override
    public WSDLBoundPortType getBoundPortType() {
        return this.owner;
    }

    public void setInputExplicitBodyParts(boolean bl) {
        this.explicitInputSOAPBodyParts = bl;
    }

    public void setOutputExplicitBodyParts(boolean bl) {
        this.explicitOutputSOAPBodyParts = bl;
    }

    public void setFaultExplicitBodyParts(boolean bl) {
        this.explicitFaultSOAPBodyParts = bl;
    }

    public void setStyle(SOAPBinding.Style style) {
        this.style = style;
    }

    @Override
    @Nullable
    public QName getReqPayloadName() {
        if (this.emptyRequestPayload) {
            return null;
        }
        if (this.requestPayloadName != null) {
            return this.requestPayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String string = this.getRequestNamespace() != null ? this.getRequestNamespace() : this.name.getNamespaceURI();
            this.requestPayloadName = new QName(string, this.name.getLocalPart());
            return this.requestPayloadName;
        }
        QName qName = this.operation.getInput().getMessage().getName();
        WSDLMessageImpl wSDLMessageImpl = this.messages.get(qName);
        for (WSDLPartImpl wSDLPartImpl : wSDLMessageImpl.parts()) {
            ParameterBinding parameterBinding = this.getInputBinding(wSDLPartImpl.getName());
            if (!parameterBinding.isBody()) continue;
            this.requestPayloadName = wSDLPartImpl.getDescriptor().name();
            return this.requestPayloadName;
        }
        this.emptyRequestPayload = true;
        return null;
    }

    @Nullable
    public QName getResPayloadName() {
        if (this.emptyResponsePayload) {
            return null;
        }
        if (this.responsePayloadName != null) {
            return this.responsePayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String string = this.getResponseNamespace() != null ? this.getResponseNamespace() : this.name.getNamespaceURI();
            this.responsePayloadName = new QName(string, this.name.getLocalPart() + "Response");
            return this.responsePayloadName;
        }
        QName qName = this.operation.getOutput().getMessage().getName();
        WSDLMessageImpl wSDLMessageImpl = this.messages.get(qName);
        for (WSDLPartImpl wSDLPartImpl : wSDLMessageImpl.parts()) {
            ParameterBinding parameterBinding = this.getOutputBinding(wSDLPartImpl.getName());
            if (!parameterBinding.isBody()) continue;
            this.responsePayloadName = wSDLPartImpl.getDescriptor().name();
            return this.responsePayloadName;
        }
        this.emptyResponsePayload = true;
        return null;
    }

    public String getRequestNamespace() {
        return this.reqNamespace != null ? this.reqNamespace : this.name.getNamespaceURI();
    }

    public void setRequestNamespace(String string) {
        this.reqNamespace = string;
    }

    public String getResponseNamespace() {
        return this.respNamespace != null ? this.respNamespace : this.name.getNamespaceURI();
    }

    public void setResponseNamespace(String string) {
        this.respNamespace = string;
    }

    WSDLBoundPortTypeImpl getOwner() {
        return this.owner;
    }

    void freeze(WSDLModelImpl wSDLModelImpl) {
        this.messages = wSDLModelImpl.getMessages();
        this.operation = this.owner.getPortType().get(this.name.getLocalPart());
        for (WSDLBoundFaultImpl wSDLBoundFaultImpl : this.wsdlBoundFaults) {
            wSDLBoundFaultImpl.freeze(this);
        }
    }

    public void setAnonymous(WSDLBoundOperation.ANONYMOUS aNONYMOUS) {
        this.anonymous = aNONYMOUS;
    }

    @Override
    public WSDLBoundOperation.ANONYMOUS getAnonymous() {
        return this.anonymous;
    }
}

