/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind;

import com.sun.xml.internal.bind.Messages;
import com.sun.xml.internal.bind.WhiteSpaceProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class DatatypeConverterImpl {
    private static final byte[] decodeMap = DatatypeConverterImpl.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = DatatypeConverterImpl.initEncodeMap();
    private static final Map<ClassLoader, DatatypeFactory> DF_CACHE = Collections.synchronizedMap(new WeakHashMap());

    protected DatatypeConverterImpl() {
    }

    public static BigInteger _parseInteger(CharSequence charSequence) {
        return new BigInteger(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    public static String _printInteger(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    public static int _parseInt(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (WhiteSpaceProcessor.isWhiteSpace(c)) continue;
            if ('0' <= c && c <= '9') {
                n3 = n3 * 10 + (c - 48);
                continue;
            }
            if (c == '-') {
                n2 = -1;
                continue;
            }
            if (c == '+') continue;
            throw new NumberFormatException("Not a number: " + charSequence);
        }
        return n3 * n2;
    }

    public static long _parseLong(CharSequence charSequence) {
        return Long.valueOf(DatatypeConverterImpl.removeOptionalPlus(WhiteSpaceProcessor.trim(charSequence)).toString());
    }

    public static short _parseShort(CharSequence charSequence) {
        return (short)DatatypeConverterImpl._parseInt(charSequence);
    }

    public static String _printShort(short s) {
        return String.valueOf(s);
    }

    public static BigDecimal _parseDecimal(CharSequence charSequence) {
        if ((charSequence = WhiteSpaceProcessor.trim(charSequence)).length() <= 0) {
            return null;
        }
        return new BigDecimal(charSequence.toString());
    }

    public static float _parseFloat(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        if (string.equals("NaN")) {
            return Float.NaN;
        }
        if (string.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
            throw new NumberFormatException();
        }
        return Float.parseFloat(string);
    }

    public static String _printFloat(float f) {
        if (Float.isNaN(f)) {
            return "NaN";
        }
        if (f == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (f == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(f);
    }

    public static double _parseDouble(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        if (string.equals("NaN")) {
            return Double.NaN;
        }
        if (string.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (string.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (string.length() == 0 || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(0)) || !DatatypeConverterImpl.isDigitOrPeriodOrSign(string.charAt(string.length() - 1))) {
            throw new NumberFormatException(string);
        }
        return Double.parseDouble(string);
    }

    public static Boolean _parseBoolean(CharSequence charSequence) {
        char c;
        if (charSequence == null) {
            return null;
        }
        int n = 0;
        int n2 = charSequence.length();
        boolean bl = false;
        if (charSequence.length() <= 0) {
            return null;
        }
        while (WhiteSpaceProcessor.isWhiteSpace(c = charSequence.charAt(n++)) && n < n2) {
        }
        int n3 = 0;
        switch (c) {
            case '1': {
                bl = true;
                break;
            }
            case '0': {
                bl = false;
                break;
            }
            case 't': {
                String string = "rue";
                do {
                    c = charSequence.charAt(n++);
                } while (string.charAt(n3++) == c && n < n2 && n3 < 3);
                if (n3 == 3) {
                    bl = true;
                    break;
                }
                return false;
            }
            case 'f': {
                String string = "alse";
                do {
                    c = charSequence.charAt(n++);
                } while (string.charAt(n3++) == c && n < n2 && n3 < 4);
                if (n3 == 4) {
                    bl = false;
                    break;
                }
                return false;
            }
        }
        if (n < n2) {
            while (WhiteSpaceProcessor.isWhiteSpace(c = charSequence.charAt(n++)) && n < n2) {
            }
        }
        if (n == n2) {
            return bl;
        }
        return null;
    }

    public static String _printBoolean(boolean bl) {
        return bl ? "true" : "false";
    }

    public static byte _parseByte(CharSequence charSequence) {
        return (byte)DatatypeConverterImpl._parseInt(charSequence);
    }

    public static String _printByte(byte by) {
        return String.valueOf(by);
    }

    public static QName _parseQName(CharSequence charSequence, NamespaceContext namespaceContext) {
        String string;
        String string2;
        String string3;
        int n;
        int n2;
        int n3;
        int n4 = charSequence.length();
        for (n3 = 0; n3 < n4 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n3)); ++n3) {
        }
        for (n2 = n4; n2 > n3 && WhiteSpaceProcessor.isWhiteSpace(charSequence.charAt(n2 - 1)); --n2) {
        }
        if (n2 == n3) {
            throw new IllegalArgumentException("input is empty");
        }
        for (n = n3 + 1; n < n2 && charSequence.charAt(n) != ':'; ++n) {
        }
        if (n == n2) {
            string3 = namespaceContext.getNamespaceURI("");
            string2 = charSequence.subSequence(n3, n2).toString();
            string = "";
        } else {
            string = charSequence.subSequence(n3, n).toString();
            string2 = charSequence.subSequence(n + 1, n2).toString();
            string3 = namespaceContext.getNamespaceURI(string);
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException("prefix " + string + " is not bound to a namespace");
            }
        }
        return new QName(string3, string2, string);
    }

    public static GregorianCalendar _parseDateTime(CharSequence charSequence) {
        String string = WhiteSpaceProcessor.trim(charSequence).toString();
        return DatatypeConverterImpl.getDatatypeFactory().newXMLGregorianCalendar(string).toGregorianCalendar();
    }

    public static String _printDateTime(Calendar calendar) {
        return CalendarFormatter.doFormat("%Y-%M-%DT%h:%m:%s%z", calendar);
    }

    public static String _printDate(Calendar calendar) {
        return CalendarFormatter.doFormat("%Y-%M-%D" + "%z", calendar);
    }

    public static String _printInt(int n) {
        return String.valueOf(n);
    }

    public static String _printLong(long l) {
        return String.valueOf(l);
    }

    public static String _printDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toPlainString();
    }

    public static String _printDouble(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "INF";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return String.valueOf(d);
    }

    public static String _printQName(QName qName, NamespaceContext namespaceContext) {
        String string = namespaceContext.getPrefix(qName.getNamespaceURI());
        String string2 = qName.getLocalPart();
        String string3 = string == null || string.length() == 0 ? string2 : string + ':' + string2;
        return string3;
    }

    private static byte[] initDecodeMap() {
        int n;
        byte[] byArray = new byte[128];
        for (n = 0; n < 128; ++n) {
            byArray[n] = -1;
        }
        for (n = 65; n <= 90; ++n) {
            byArray[n] = (byte)(n - 65);
        }
        for (n = 97; n <= 122; ++n) {
            byArray[n] = (byte)(n - 97 + 26);
        }
        for (n = 48; n <= 57; ++n) {
            byArray[n] = (byte)(n - 48 + 52);
        }
        byArray[43] = 62;
        byArray[47] = 63;
        byArray[61] = 127;
        return byArray;
    }

    private static int guessLength(String string) {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            n = decodeMap[string.charAt(n2)];
            if (n == 127) continue;
            if (n != -1) break;
            return string.length() / 4 * 3;
        }
        if ((n = n3 - ++n2) > 2) {
            return string.length() / 4 * 3;
        }
        return string.length() / 4 * 3 - n;
    }

    public static byte[] _parseBase64Binary(String string) {
        int n = DatatypeConverterImpl.guessLength(string);
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = string.length();
        byte[] byArray2 = new byte[4];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            byte by = decodeMap[c];
            if (by != -1) {
                byArray2[n4++] = by;
            }
            if (n4 != 4) continue;
            byArray[n2++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            if (byArray2[2] != 127) {
                byArray[n2++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            }
            if (byArray2[3] != 127) {
                byArray[n2++] = (byte)(byArray2[2] << 6 | byArray2[3]);
            }
            n4 = 0;
        }
        if (n == n2) {
            return byArray;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        return byArray3;
    }

    private static char[] initEncodeMap() {
        int n;
        char[] cArray = new char[64];
        for (n = 0; n < 26; ++n) {
            cArray[n] = (char)(65 + n);
        }
        for (n = 26; n < 52; ++n) {
            cArray[n] = (char)(97 + (n - 26));
        }
        for (n = 52; n < 62; ++n) {
            cArray[n] = (char)(48 + (n - 52));
        }
        cArray[62] = 43;
        cArray[63] = 47;
        return cArray;
    }

    public static char encode(int n) {
        return encodeMap[n & 0x3F];
    }

    public static byte encodeByte(int n) {
        return (byte)encodeMap[n & 0x3F];
    }

    public static String _printBase64Binary(byte[] byArray) {
        return DatatypeConverterImpl._printBase64Binary(byArray, 0, byArray.length);
    }

    public static String _printBase64Binary(byte[] byArray, int n, int n2) {
        char[] cArray = new char[(n2 + 2) / 3 * 4];
        int n3 = DatatypeConverterImpl._printBase64Binary(byArray, n, n2, cArray, 0);
        assert (n3 == cArray.length);
        return new String(cArray);
    }

    public static int _printBase64Binary(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        int n4 = n2;
        int n5 = n;
        while (n4 >= 3) {
            cArray[n3++] = DatatypeConverterImpl.encode(byArray[n5] >> 2);
            cArray[n3++] = DatatypeConverterImpl.encode((byArray[n5] & 3) << 4 | byArray[n5 + 1] >> 4 & 0xF);
            cArray[n3++] = DatatypeConverterImpl.encode((byArray[n5 + 1] & 0xF) << 2 | byArray[n5 + 2] >> 6 & 3);
            cArray[n3++] = DatatypeConverterImpl.encode(byArray[n5 + 2] & 0x3F);
            n4 -= 3;
            n5 += 3;
        }
        if (n4 == 1) {
            cArray[n3++] = DatatypeConverterImpl.encode(byArray[n5] >> 2);
            cArray[n3++] = DatatypeConverterImpl.encode((byArray[n5] & 3) << 4);
            cArray[n3++] = 61;
            cArray[n3++] = 61;
        }
        if (n4 == 2) {
            cArray[n3++] = DatatypeConverterImpl.encode(byArray[n5] >> 2);
            cArray[n3++] = DatatypeConverterImpl.encode((byArray[n5] & 3) << 4 | byArray[n5 + 1] >> 4 & 0xF);
            cArray[n3++] = DatatypeConverterImpl.encode((byArray[n5 + 1] & 0xF) << 2);
            cArray[n3++] = 61;
        }
        return n3;
    }

    public static void _printBase64Binary(byte[] byArray, int n, int n2, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        int n3 = n2;
        char[] cArray = new char[4];
        int n4 = n;
        while (n3 >= 3) {
            cArray[0] = DatatypeConverterImpl.encode(byArray[n4] >> 2);
            cArray[1] = DatatypeConverterImpl.encode((byArray[n4] & 3) << 4 | byArray[n4 + 1] >> 4 & 0xF);
            cArray[2] = DatatypeConverterImpl.encode((byArray[n4 + 1] & 0xF) << 2 | byArray[n4 + 2] >> 6 & 3);
            cArray[3] = DatatypeConverterImpl.encode(byArray[n4 + 2] & 0x3F);
            xMLStreamWriter.writeCharacters(cArray, 0, 4);
            n3 -= 3;
            n4 += 3;
        }
        if (n3 == 1) {
            cArray[0] = DatatypeConverterImpl.encode(byArray[n4] >> 2);
            cArray[1] = DatatypeConverterImpl.encode((byArray[n4] & 3) << 4);
            cArray[2] = 61;
            cArray[3] = 61;
            xMLStreamWriter.writeCharacters(cArray, 0, 4);
        }
        if (n3 == 2) {
            cArray[0] = DatatypeConverterImpl.encode(byArray[n4] >> 2);
            cArray[1] = DatatypeConverterImpl.encode((byArray[n4] & 3) << 4 | byArray[n4 + 1] >> 4 & 0xF);
            cArray[2] = DatatypeConverterImpl.encode((byArray[n4 + 1] & 0xF) << 2);
            cArray[3] = 61;
            xMLStreamWriter.writeCharacters(cArray, 0, 4);
        }
    }

    public static int _printBase64Binary(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = byArray2;
        int n4 = n2;
        int n5 = n;
        while (n4 >= 3) {
            byArray3[n3++] = DatatypeConverterImpl.encodeByte(byArray[n5] >> 2);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte((byArray[n5] & 3) << 4 | byArray[n5 + 1] >> 4 & 0xF);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte((byArray[n5 + 1] & 0xF) << 2 | byArray[n5 + 2] >> 6 & 3);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte(byArray[n5 + 2] & 0x3F);
            n4 -= 3;
            n5 += 3;
        }
        if (n4 == 1) {
            byArray3[n3++] = DatatypeConverterImpl.encodeByte(byArray[n5] >> 2);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte((byArray[n5] & 3) << 4);
            byArray3[n3++] = 61;
            byArray3[n3++] = 61;
        }
        if (n4 == 2) {
            byArray3[n3++] = DatatypeConverterImpl.encodeByte(byArray[n5] >> 2);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte((byArray[n5] & 3) << 4 | byArray[n5 + 1] >> 4 & 0xF);
            byArray3[n3++] = DatatypeConverterImpl.encodeByte((byArray[n5 + 1] & 0xF) << 2);
            byArray3[n3++] = 61;
        }
        return n3;
    }

    private static CharSequence removeOptionalPlus(CharSequence charSequence) {
        int n = charSequence.length();
        if (n <= 1 || charSequence.charAt(0) != '+') {
            return charSequence;
        }
        char c = (charSequence = charSequence.subSequence(1, n)).charAt(0);
        if ('0' <= c && c <= '9') {
            return charSequence;
        }
        if ('.' == c) {
            return charSequence;
        }
        throw new NumberFormatException();
    }

    private static boolean isDigitOrPeriodOrSign(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        return c == '+' || c == '-' || c == '.';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatatypeFactory getDatatypeFactory() {
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        DatatypeFactory datatypeFactory = DF_CACHE.get(classLoader);
        if (datatypeFactory != null) return datatypeFactory;
        Class<DatatypeConverterImpl> clazz = DatatypeConverterImpl.class;
        synchronized (DatatypeConverterImpl.class) {
            datatypeFactory = DF_CACHE.get(classLoader);
            if (datatypeFactory != null) return datatypeFactory;
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new Error(Messages.FAILED_TO_INITIALE_DATATYPE_FACTORY.format(new Object[0]), datatypeConfigurationException);
            }
            DF_CACHE.put(classLoader, datatypeFactory);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return datatypeFactory;
        }
    }

    private static final class CalendarFormatter {
        private CalendarFormatter() {
        }

        public static String doFormat(String string, Calendar calendar) throws IllegalArgumentException {
            int n = 0;
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            block9: while (n < n2) {
                char c;
                if ((c = string.charAt(n++)) != '%') {
                    stringBuilder.append(c);
                    continue;
                }
                switch (string.charAt(n++)) {
                    case 'Y': {
                        CalendarFormatter.formatYear(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'M': {
                        CalendarFormatter.formatMonth(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'D': {
                        CalendarFormatter.formatDays(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'h': {
                        CalendarFormatter.formatHours(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'm': {
                        CalendarFormatter.formatMinutes(calendar, stringBuilder);
                        continue block9;
                    }
                    case 's': {
                        CalendarFormatter.formatSeconds(calendar, stringBuilder);
                        continue block9;
                    }
                    case 'z': {
                        CalendarFormatter.formatTimeZone(calendar, stringBuilder);
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            return stringBuilder.toString();
        }

        private static void formatYear(Calendar calendar, StringBuilder stringBuilder) {
            int n = calendar.get(1);
            String string = n <= 0 ? Integer.toString(1 - n) : Integer.toString(n);
            while (string.length() < 4) {
                string = '0' + string;
            }
            if (n <= 0) {
                string = '-' + string;
            }
            stringBuilder.append(string);
        }

        private static void formatMonth(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(2) + 1, stringBuilder);
        }

        private static void formatDays(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(5), stringBuilder);
        }

        private static void formatHours(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(11), stringBuilder);
        }

        private static void formatMinutes(Calendar calendar, StringBuilder stringBuilder) {
            CalendarFormatter.formatTwoDigits(calendar.get(12), stringBuilder);
        }

        private static void formatSeconds(Calendar calendar, StringBuilder stringBuilder) {
            int n;
            CalendarFormatter.formatTwoDigits(calendar.get(13), stringBuilder);
            if (calendar.isSet(14) && (n = calendar.get(14)) != 0) {
                String string = Integer.toString(n);
                while (string.length() < 3) {
                    string = '0' + string;
                }
                stringBuilder.append('.');
                stringBuilder.append(string);
            }
        }

        private static void formatTimeZone(Calendar calendar, StringBuilder stringBuilder) {
            TimeZone timeZone = calendar.getTimeZone();
            if (timeZone == null) {
                return;
            }
            int n = timeZone.getOffset(calendar.getTime().getTime());
            if (n == 0) {
                stringBuilder.append('Z');
                return;
            }
            if (n >= 0) {
                stringBuilder.append('+');
            } else {
                stringBuilder.append('-');
                n *= -1;
            }
            CalendarFormatter.formatTwoDigits((n /= 60000) / 60, stringBuilder);
            stringBuilder.append(':');
            CalendarFormatter.formatTwoDigits(n % 60, stringBuilder);
        }

        private static void formatTwoDigits(int n, StringBuilder stringBuilder) {
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
        }
    }
}

