#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <windows.h>
#include <time.h>
#include <direct.h>

#define BUFFERLEN 1000
#define MaxFileLen 255
#define MaxInsLen 1000

void errorform(char *errorstring, char *errortitle);
void cleanup(char *ackFileName, char *datFileName, char *atnFileName);

void main(int argc,char *argv[]) {

char tmpname[MaxFileLen];
char *datFileName,*ackFileName,*atnFileName;
FILE *datFile,*atnFile,*tempFile,*tFH;
char buffer[BUFFERLEN],*t1,*tempbuffer,*cgiPath;
int cont_len,bytesread;
time_t begintout, chktout;
char **envptr;

tmpnam(tmpname);
 
cgiPath="\\temp";
_mkdir(cgiPath);

//Turn stdin buffering off
setvbuf(stdin,NULL,_IONBF,0);

datFileName=(char *)malloc(sizeof(cgiPath)+sizeof(tmpname)+5);
ackFileName=(char *)malloc(sizeof(cgiPath)+sizeof(tmpname)+5);
atnFileName=(char *)malloc(sizeof(cgiPath)+sizeof(tmpname)+5);

// Create the names for the three files.
sprintf(datFileName,"%s\\%sdat\0",cgiPath,tmpname);
sprintf(ackFileName,"%s\\%sack\0",cgiPath,tmpname);
sprintf(atnFileName,"%s\\%satn\0",cgiPath,tmpname);

//Create Data File
datFile = fopen(datFileName,"w");
if (datFile == NULL) {
	errorform("Communication with the server is not possible at this time.","Server Inaccessible");
	cleanup(ackFileName,datFileName,atnFileName);
	return;
	}


//We could check REQUEST_METHOD here, but what would be the point?
//If CONTENT_LENGTH is NULL, we won't read the stdin, otherwise we will.
//This is entirely for POST method requests.
t1 = getenv("CONTENT_LENGTH");
if (t1 != NULL) {
	cont_len = atoi(t1);

	tempbuffer=(char *)malloc(sizeof(char)*cont_len);
	if (tempbuffer == NULL)
		{
		cleanup(ackFileName,datFileName,atnFileName);
		return;
		}

	bytesread=fread(tempbuffer,sizeof(char),cont_len,stdin);
	if (bytesread!=0)
		fwrite(tempbuffer,sizeof(char),bytesread,datFile);

	free(tempbuffer);
}

//This part reads all of the environment variables and sends
//them along in the DAT file as well.  All ampersand delimited.
envptr=environ;
while (*envptr != NULL)
{
	fputs("&",datFile);
	fputs(*envptr,datFile);
	envptr++;
}

fclose(datFile);

//Create Atn File
atnFile = fopen(atnFileName,"w");
if (atnFile == NULL) {
	errorform("Communication with the server is not possible at this time.","Server Inaccessible");
	cleanup(ackFileName,datFileName,atnFileName);
	return;
	}
fclose(atnFile);

_flushall();


// Wait for Server to ACK
time(&begintout);
do {
	tempFile = fopen(ackFileName,"r");
	time(&chktout);
	Sleep(250);
} while ((tempFile == NULL) && (difftime(chktout,begintout) < 60));

if (tempFile != NULL)
	fclose(tempFile);
else
	{
	errorform("The server timed out.  It is probably too busy to fulfill your request.","Server Timeout");
	cleanup(ackFileName,datFileName,atnFileName);
	return;
	}

// Send the Data file to stdout.
datFile = fopen(datFileName,"r");
if (datFile == NULL) {
	errorform("A server error occurred.  No return data was sent.", "Server Error");
	cleanup(ackFileName,datFileName,atnFileName);
	return;
	}
else {
	while (!feof(datFile))
		{
		if (fgets(buffer,BUFFERLEN,datFile) != NULL)
			printf("%s",buffer);
		} 
	fclose(datFile);
	}

// Cleanup all files and free allocated memory.
cleanup(ackFileName,datFileName,atnFileName);

}

void errorform(char *errorstring, char *errortitle)
{
	printf("Content-Type: text/html\n\n");
	printf("<head><title>%s</title></head>\n",errortitle);
	printf("<body>\n<h1>%s</h1>\n",errortitle);
	printf("%s<hr>\n",errorstring);
}

void cleanup(char *ackFileName, char *datFileName, char *atnFileName)
{
	if (ackFileName != NULL)
		{
		remove(ackFileName);
		free(ackFileName);
		}
	if (datFileName != NULL)
		{
		remove(datFileName);
		free(datFileName);
		}
	if (atnFileName != NULL)
		{
		remove(atnFileName);
		free(atnFileName);
		}

}
