* ADD_READ.PRG
* called by Demo Coverage AddIns, 
* to provide help information about AddIns

LPARAMETERS tcFileName

ASSERT TYPE("tcFileName") = "C" AND ;
       NOT EMPTY(SYS(2000,tcFileName)) ;
       MESSAGE "This program is designed to be called ONLY "+CHR(13)+ ;
               "by sample Coverage AddIns with their program names!"

#DEFINE COV_ADDIN_HELP_FORM  "ADD_READ.SCX"
#DEFINE COV_GENERAL_README   "ADD_READ.TXT"

LOCAL cThisReadMeFile, cGeneralReadMeFile, cPath, cWind

cThisReadMeFile = UPPER(tcFileName)

IF LEFT(cThisReadMeFile,10) = "PROCEDURE "
   cThisReadMeFile = ;
     SUBSTR(cThisReadMeFile,AT(" ",cThisReadMeFile,2) + 1)
ENDIF

cPath = LEFT(cThisReadMeFile,RAT("\",cThisReadMeFile))  

cGeneralReadMeFile = COV_GENERAL_README

IF NOT FILE(cGeneralReadMeFile)
   cGeneralReadMeFile = cPath + COV_GENERAL_README
ENDIF
   
cThisReadMeFile = SUBSTR(cThisReadMeFile, 1, ;
                  AT(".",cThisReadMeFile))+"TXT"

IF NOT FILE(cGeneralReadMeFile)
   cGeneralReadMeFile = ""
ENDIF                     
IF NOT FILE(cThisReadMeFile)
   cThisReadMeFile = ""
ENDIF                     

     
DO CASE

CASE EMPTY(cGeneralReadMeFile) AND ;
     EMPTY(cThisReadMeFile)
     
   WAIT WINDOW TIMEOUT 1  ;
       "No help available for AddIn Samples!"

CASE FILE(COV_ADDIN_HELP_FORM)

  DO FORM (COV_ADDIN_HELP_FORM) ;
      WITH cGeneralReadMeFile, cThisReadMeFile

CASE FILE(cPath+COV_ADDIN_HELP_FORM)
   
   DO FORM (cPath+COV_ADDIN_HELP_FORM) ;
      WITH cGeneralReadMeFile, cThisReadMeFile

OTHERWISE
   
   IF TYPE("_oCoverage.frmMainDialog.Name") = "C"
   
      cWind = "WINDOW "+_oCoverage.frmMainDialog.Name

   ELSE

      cWind = ""

   ENDIF

   IF NOT EMPTY(cGeneralReadMeFile)
      MODI FILE (cGeneralReadMeFile) ;
           &cWind ;
           NOEDIT ;
           RANGE 0,0
   ENDIF

   IF NOT EMPTY(cThisReadMeFile)
      MODI FILE (cThisReadMeFile) ;
           &cWind ;
           NOEDIT ;
           RANGE 0,0
   ENDIF

ENDCASE


RETURN