* COVERAGE WRAPPER PRG

#INCLUDE COVERAGE.H

LPARAMETERS tcFile, tlUnattended, tcAddIn

LOCAL oTemp, cAlias, lSuccess, lSetTalkBackOn, cAppFile ;
      cLibs, cUnattendedMessage, cSavedTarget, cSavedSkippedFiles

IF (SET("TALK") = "ON")
   SET TALK OFF
   lSetTalkBackOn = .T.
ENDIF

cLibs = SET("CLASSLIB")

cAlias = "C_"+SYS(2015)
cAppFile = FindAppFile()
* this is only necessary 
* in cases where this wrapper program
* and its app get embedded in a temporary
* program, such as when you highlight several
* lines of code and interactively Execute them...

IF FILE(COV_CLASSLIB) OR EMPTY(cAppFile)
   SET CLASSLIB TO (COV_CLASSLIB) ALIAS (cAlias) ADDITIVE
ELSE
   SET CLASSLIB TO (COV_CLASSLIB) IN (cAppFile) ALIAS (cAlias) ADDITIVE
ENDIF

oTemp = CREATEOBJECT(cAlias+"."+COV_CLASS_TO_INSTANCE, ;
                     tcFile, tlUnattended, tcAddIn)
* NB: the actual public reference variable
* is not the responsibility of the wrapper program;
* it's set up (and released when necessary)
* by the object itself.

lSuccess = (TYPE("oTemp.BaseClass") = "C")

IF lSuccess
   IF tlUnattended
      * oTemp.cSavedTargetDBF will have the
      * marked code results file,
      * and another table with the same
      * name + numeric extension as your
      * passed coverage log (in the same
      * directory as the log)
      * will show you what records were skipped
      * if some source files were not found:
      cSavedTarget = oTemp.cSavedTargetDBF
      cSavedSkippedFiles = oTemp.cSavedSkipFiles
      lSuccess = (NOT EMPTY(cSavedTarget))
      IF lSuccess
         cUnattendedMessage = COV_SAVEDTARGET_AS_LOC+C_CR+ ;
            cSavedTarget+"." 
         IF NOT EMPTY(cSavedSkippedFiles)
            cUnattendedMessage = cUnattendedMessage + ;
                                 C_DOUBLE_CR+;
                                 COV_SAVEDSKIPFILES_AS_LOC+C_CR+;
                                 "("+cSavedSkippedFiles+")."
         ENDIF
         MESSAGEBOX(cUnattendedMessage, COV_APPLICATION_NAME_LOC)
      ENDIF
      oTemp.Release()
   ELSE
      oTemp.Show()
   ENDIF
ELSE
   CLEAR CLASS COV_CLASS_TO_INSTANCE
ENDIF

SET CLASSLIB TO &cLibs

IF lSetTalkBackOn
   SET TALK ON
ENDIF

IF NOT EMPTY(cSavedSkippedFiles)
   SELECT 0
   USE (cSavedSkippedFiles)
   BROWSE NOWAIT WIDTH 30
   MOVE WINDOW (WONTOP()) TO 0,0
ENDIF

IF NOT EMPTY(cSavedTarget)
   SELECT 0
   USE (cSavedTarget)
   BROWSE NOWAIT WIDTH 30
   MOVE WINDOW (WONTOP()) TO 5,5   
ENDIF

RETURN lSuccess


PROCEDURE FindAppFile
LOCAL cFileName, cSys16, iLevel
* get the name of the module (app or exe) that
* owns this particular object, for SET CLASSLIB ... IN...
cFileName = ""
FOR iLevel = 256 TO 1 STEP -1 && 256 = twice the nested programs currently allowed!
  cSys16 = UPPER(SYS(16,iLevel))
  IF INLIST(RIGHT(cSys16,3),"APP","EXE","VFD","DLL")
     cFileName = cSys16
     EXIT
  ENDIF
ENDFOR

RETURN cFileName