package com.test.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import org.apache.catalina.authenticator.SavedRequest;


public class FileUtil {
	
	private final String SEP = File.separator;
	int count = 0;

	
	public static String [] getFileName(String path){ 
        File file = new File(path); 
        String [] fileName = file.list(); 
        return fileName; 
    } 
	
	public  boolean isFileExist(String path) {
		try {
			File file = new File(path);
			return file.exists();
		} catch (Exception ex) {
			ex.printStackTrace();
		}

		return false;
	}
	
	public  boolean mkDir(String path) {
		File dir = new File(path);
		boolean res = dir.mkdirs();
		return res;
	}

	public List<String> readTxtFile(String filePath) {
		List<String> resultList = new ArrayList<>();
		try {
			String encoding = "UTF-8";
			File file = new File(filePath);
			if (file.isFile() && file.exists()) { // 判断文件是否存在
				InputStreamReader read = new InputStreamReader(new FileInputStream(file), encoding);// 考虑到编码格式
				BufferedReader bufferedReader = new BufferedReader(read);
				String lineTxt = null;
				while ((lineTxt = bufferedReader.readLine()) != null) {
					if(lineTxt.length() < 2){
						continue;
					}else {
						resultList.add(lineTxt);
					}
				}
				read.close();
			} else {
				System.out.println("找不到指定的文件");
			}
		} catch (Exception e) {
			System.out.println("读取文件内容出错");
			e.printStackTrace();
		}
		return resultList; 
	}
	
	
	public List<String> readTxtFileByPath(String filePath,String Path) {
	    String savePath = "c:\\"+Path;
		List<String> resultList = new ArrayList<>();
		try {
			String encoding = "UTF-8";
			File file = new File(filePath);
			if (file.isFile() && file.exists()) { // 判断文件是否存在
				InputStreamReader read = new InputStreamReader(new FileInputStream(file), encoding);// 考虑到编码格式
				BufferedReader bufferedReader = new BufferedReader(read);
				String lineTxt = null;
				int lineNumber = 0;
				while ((lineTxt = bufferedReader.readLine()) != null) {
					lineNumber++;
					System.out.println("lineNumber "+lineNumber);
					if(lineTxt.length() < 2){
						continue;
					}else {
						String lastRead = lineTxt.substring(lineTxt.lastIndexOf("|")+1,lineTxt.length());
						String fristRead = lineTxt.substring(0,lineTxt.indexOf("|"));
						if(lastRead.toUpperCase().equals(savePath.toUpperCase())){
							
							File savePathFile = new File(savePath);
							File[] files = savePathFile.listFiles();
							
							if(files.length == 0){//當文件夾所有文件不存在時
								lineTxt = "";
								System.out.println("none file of "+savePath);
							}else {
								boolean fileDelete = true;
								for (int i = 0; i < files.length; i++) {
									System.out.println("files" + files[i].getName());
									System.out.println("fristRead"+fristRead);
									if(fristRead.equals(files[i].getName())){
										//當文件列表中存在一則記錄文件名與列表文件名匹配時,證明文件沒有被刪除
										fileDelete = false;
									}
								}
								if (fileDelete) {
									//文件是否被刪除，是：刪除該條記錄；否：記錄應當存留
									deleteLineText(lineNumber);
								}else {
									resultList.add(lineTxt);
								}
							}				
						}
					}
					
				}
				read.close();
			} else {
				System.out.println("找不到指定的文件");
			}
		} catch (Exception e) {
			System.out.println("读取文件内容出错");
			e.printStackTrace();
		}
		return resultList; 
	}
	
	
	
	public void deleteLineText(int lineNum){
//		BufferedReader br;
		try {
//			br = new   BufferedReader(new FileReader("c:/a.txt "));
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("c:\\a.txt"),"UTF-8"));  
			StringBuffer sb=new StringBuffer(4096);
			String temp=null;
			int   line=0;
			
			while((temp=br.readLine())!=null){
			        line++;
			        if(line==lineNum)   
			        	continue;
			        sb.append(temp).append("\r\n");
//			        sb.append(new String(temp.getBytes("Unicode"), "UTF-8")).append( "\r\n ");
			}
			br.close();
			OutputStreamWriter write = new OutputStreamWriter(new FileOutputStream("c:/a.txt "),"UTF-8");      
	        BufferedWriter writer=new BufferedWriter(write); 
//			BufferedWriter   bw=new   BufferedWriter(new FileWriter( "c:/a.txt "));
			writer.write(sb.toString());
			writer.close();
		} catch (FileNotFoundException e) {
			System.out.println(e.toString());
			e.printStackTrace();
		} catch (IOException e) {
			System.out.println(e.toString());
			e.printStackTrace();
		}
		
	}
	

	public void writeTxtFile(File file, String fileContent)   
	{     
	    try   
	    {      
	        OutputStreamWriter write = new OutputStreamWriter(new FileOutputStream(file),"UTF-8");      
	        BufferedWriter writer=new BufferedWriter(write);  
	        writer.write(fileContent);      
	        writer.close();     
	    } catch (Exception e)   
	    {      
	        e.printStackTrace();     
	    }  
	}
	
	
	public int[] getAllFileSize(String[] filePath){
		int[] fileSizeArray = new int[filePath.length];
		for (int i = 0; i < filePath.length; i++) {
			if(!isFileExist("c:\\"+filePath[i])){
				mkDir("c:\\"+filePath[i]);
			}
			File file = new File("c:\\"+filePath[i]);
			File[] files = file.listFiles();
			fileSizeArray[i] = files.length;
		}
		return fileSizeArray;

	}
	
	public String deleteFile(){
		String result = "";
		if(count == 0){
			System.out.println("0");
			result = "0";
		}else {
			System.out.println("deleteFile");
			result = "deleteFile";
		}
		count++;
		return result;
	}
	
	public void appendMethod(String content) {
		
        try {
        	File file = new File("C:\\a.txt");
        	if (!file.exists()){       
        		 file.createNewFile();
 	            writeTxtFile(file,content);
 	        }else {
 	         Writer out = new BufferedWriter( new OutputStreamWriter(new FileOutputStream("C:\\a.txt",true),"UTF-8"));
 	         out.write("\r\n"+content);
 	         out.close();
			}
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
	
	
	public static boolean copyFile(String fromFile, String toFile) {
		try {
			InputStream fosfrom = new FileInputStream(fromFile);
			OutputStream fosto = new FileOutputStream(toFile);
			byte bt[] = new byte[4096];
			int c;
			while ((c = fosfrom.read(bt)) > 0) {
				fosto.write(bt, 0, c);
			}
			fosfrom.close();
			fosto.close();
			bt = null;
			return true;

		} catch (Exception ex) {
			ex.printStackTrace();
			return false;
		}
	}	
}
