package com.bijian.study;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import com.test.util.FileUtil;

@SuppressWarnings("serial")
public class Upload extends HttpServlet {
	
	private final String SEP = File.separator;
	private FileUtil fUtil = new FileUtil();

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String savePath = this.getServletConfig().getServletContext()
				.getRealPath("");
		savePath = savePath + "/uploads/";

		File f1 = new File(savePath);
		System.out.println(savePath);
		if (!f1.exists()) {
			f1.mkdirs();
		}
		DiskFileItemFactory fac = new DiskFileItemFactory();
		ServletFileUpload upload = new ServletFileUpload(fac);
		upload.setHeaderEncoding("utf-8");

		String package_path = request.getParameter("save_path");
		String remark = request.getParameter("remark");

		List fileList = null;
		try {
			fileList = upload.parseRequest(request);
		} catch (FileUploadException ex) {
			return;
		}
		Iterator<FileItem> it = fileList.iterator();
		String name = "";
		String extName = "";
		String sysDate = "";
		String fileFrom = "";
		while (it.hasNext()) {
			FileItem item = it.next();
			if (!item.isFormField()) {
				long size = item.getSize();
				String type = item.getContentType();
				name = item.getName();
				if (name == null || name.trim().equals("")) {
					continue;
				}
				if (name.lastIndexOf(".") >= 0) {
					extName = name.substring(name.lastIndexOf("."));
				}
				File file = null;
				do {
					file = new File(savePath + name + extName);
				} while (file.exists());
				File saveFile = new File(savePath + name);
				fileFrom = saveFile.getAbsolutePath();
				Date now = new Date();
				SimpleDateFormat dateFormat = new SimpleDateFormat(
						"yyyy/MM/dd HH:mm:ss");
				sysDate = dateFormat.format(now);
				try {
					item.write(saveFile);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		remark = ChangeDeocode(remark);
		package_path = ChangeDeocode(package_path);
		
		String keep_path = "C:" +SEP+ package_path+SEP+name;
		String save_path = "C:" +SEP+ package_path;
		if(!fUtil.isFileExist(save_path)){
			fUtil.mkDir("C:" +SEP+ package_path);
		}
		
		fUtil.copyFile(fileFrom, keep_path);
		if(fUtil.isFileExist(keep_path)){
			fUtil.appendMethod(name + "|" + sysDate + "|" + remark+"|"+save_path);
		}
		response.getWriter().print(name + "\\" + sysDate + "\\" + remark);
	}

	

	public String ChangeDeocode(final String dataStr) {
		String ToDeocode = "";
		if (dataStr.contains("%")) {
			char[] charArray = dataStr.toCharArray();
			int ToChangeIndex = 0;
			
			for (int i = 0; i < charArray.length; i++) {
				if (i <= ToChangeIndex && i != 0) {
					continue;
				} else {
					if (charArray[i] == '%' && charArray[i + 1] == 'u'
							&& i + 5 < charArray.length) {
						char[] tempArray = new char[] { charArray[i],
								charArray[i + 1], charArray[i + 2],
								charArray[i + 3], charArray[i + 4],
								charArray[i + 5] };
						ToDeocode += decodeUnicode(String.valueOf(tempArray));
						ToChangeIndex = i + 5;
					} else {
						ToDeocode += charArray[i];
						continue;
					}
				}
			}
		}
		return ToDeocode;
	}

	public String decodeUnicode(final String dataStr) {
		int start = 0;
		int end = 0;
		final StringBuffer buffer = new StringBuffer();
		while (start > -1) {
			end = dataStr.indexOf("\\u", start + 2);
			String charStr = "";
			if (end == -1) {
				charStr = dataStr.substring(start + 2, dataStr.length());
			} else {
				charStr = dataStr.substring(start + 2, end);
			}
			char letter = (char) Integer.parseInt(charStr, 16); // 16进制parse整形字符串。
			buffer.append(new Character(letter).toString());
			start = end;
		}
		return buffer.toString();
	}
}