local magnifyidentify = Class(function(self, inst)
    self.inst = inst
end)


function magnifyidentify:DoIdentify(target, doer)
	
    if target.components.rpgweapon and target.components.rpgweapon.discovered == false then	
		
		target.components.rpgweapon.discovered = true
		target:RemoveTag("unidentified")
		target.components.named:SetName(STRINGS.RPGITEMS.WEAPONS.NAMES[target.components.rpgweapon.currenttype] .. " ".. target.originalnamepremod)
		target.components.rpgweapon.renamed = true
		
		if self.inst.components.finiteuses then
			self.inst.components.finiteuses:Use(1)
		end
		
		if self.onsewn then
			self.onsewn(self.inst, target, doer)
		end
		
		return true
	end


	    if target.components.rpgarmor and target.components.rpgarmor.discovered == false then	
		
		target.components.rpgarmor.discovered = true
		target:RemoveTag("unidentified")
		target.components.named:SetName(STRINGS.RPGITEMS.ARMOR.NAMES[target.components.rpgarmor.currenttype] .. " ".. target.originalnamepremod)
		target.components.rpgarmor.renamed = true

		if self.inst.components.finiteuses then
			self.inst.components.finiteuses:Use(1)
		end
		
		if self.onsewn then
			self.onsewn(self.inst, target, doer)
		end
		
		return true
	end

	
end

function magnifyidentify:CollectUseActions(doer, target, actions, right)
    if target.components.rpgweapon and target.components.rpgweapon.discovered == false and target.components.rpgweapon.currenttype ~= "nonmagic"  then
        table.insert(actions, ACTIONS.MAGNIFYIDENTIFY)
    end
    if target.components.rpgarmor and target.components.rpgarmor.discovered == false and target.components.rpgarmor.currenttype ~= "nonmagic" then
        table.insert(actions, ACTIONS.MAGNIFYIDENTIFY)
    end

end

return magnifyidentify
